package gov.va.med.mhv.admin.service.mhvusers;

import java.util.Date;
import java.util.List;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

public interface PatientService {

	public PatientDTO getPatientById(Long id) throws MHVException;
	
	public List<PatientDTO> getPatientByPartialIcn(PatientDTO patientDTO) throws MHVException;

	public ResponseUtil<PatientDTO> getPatientByInvalidatedIcn(String icn, Long userProfileId) throws MHVException;

	public PatientDTO getPatientByUserProfileId(Long userProfileId) throws MHVException;
	
	public ResponseUtil<PatientDTO> getPatientByUserId(Long userProfileId) throws MHVException;

	public PatientDTO savePatient(PatientDTO patient, boolean saveUserProfile, ResponseUtil response)
			throws MHVException;

	public ResponseUtil<PatientDTO> deactivatePatientInHelpDesk(Long patientId, String referenceId, String adminNetowrkId,
			Integer reasonId, UserProfileDTO note) throws MHVException;

	public ResponseUtil<PatientDTO> reactivatePatientInHelpDesk(Long patientId, Integer reasonId, String adminNetworkId, UserProfileDTO notes)
			throws MHVException;

	public void uncorrelate(PatientDTO patient) throws MHVException;

	public PatientDTO updatePatientRegistryInformation(PatientDTO patient) throws MHVException;

	public PatientDTO deactivatePatientForMultiTraitUpdateError(Long patientId, String referenceId,
			String adminNetworkId, String reason, String note) throws MHVException;
	
	/*
		
		*//**
			 * Execute the UpdatePatientFacilities operation
			 *
			 * @param userName
			 * @param userProfile
			 * @param isMviEnabled
			 * @param response
			 */
	/*
	 * public void updatePatientFacilities(String userName, UserProfileDTO
	 * userProfile, boolean isMviEnabled, ResponseUtil response);
	 * 
	 *//**
		 * Starts the correlation with MPI of a given patient. Requires the
		 * patient to be uncorrelated.
		 *
		 * @param patient
		 * @param response
		 */
	/*
	 * public void correlate(PatientDTO patient, ResponseUtil response);
	 * 
	 *//**
		 * Execute the GetPatientFromMVI operation
		 *
		 * @param userProfile
		 * @param atRegistration
		 * @param response
		 */
	/*
	 * public void getPatientFromMVI(UserProfileDTO userProfile, Boolean
	 * atRegistration, ResponseUtil response);
	 * 
	 *//**
		 * Execute the GetPatientForFccx operation
		 *
		 * @param userProfile
		 * @param fccxIcn
		 * @param response
		 */
	/*
	 * public void createPatientForFccx(UserProfileDTO userProfile, String
	 * fccxIcn, ResponseUtil response);
	 * 
	 *//**
		 * Execute the GetPatientFromRegistryWithMiddleName operation
		 *
		 * @param firstName
		 * @param lastName
		 * @param middleName
		 * @param gender
		 * @param birthDate
		 * @param ssn
		 * @param userId
		 * @param response
		 */
	/*
	 * public void getPatientFromRegistryWithMiddleName(String firstName, String
	 * lastName, String middleName, String gender, Date birthDate, String ssn,
	 * Long userProfileId, ResponseUtil response);
	 * 
	 *//**
		 * Execute the GetPatientFromRegistry operation
		 *
		 * @param firstName
		 * @param lastName
		 * @param birthDate
		 * @param ssn
		 * @param userId
		 * @return PatientServiceResponse
		 */
	/*
	 * public void getPatientFromRegistry(String firstName, String lastName,
	 * Date birthDate, String ssn, Long userProfileId, ResponseUtil response);
	 * 
	 *//**
		 * Execute the GetPatientForUser operation
		 *
		 * @param userProfile
		 * @return PatientServiceResponse
		 */
	/*
	 * public void getPatientForUser(UserProfileDTO userProfile, ResponseUtil
	 * response);
	 * 
	 *//**
		 * Retrieve a patient for a given ICN
		 *
		 * @param icn
		 *            The ICN to lookup the patient for.
		 * @return PatientServiceResponse
		 *//*
		 * public void getPatientByIcn(String icn, ResponseUtil response);
		 */

	/*	*//**
			 * Retrieves patient by id.
			 *
			 * @param id
			 *            The id to lookup the patient for.
			 * @return PatientServiceResponse
			 */
	/*
	 * public void getPatientById(Long id, ResponseUtil response);
	 * 
	 *//**
		 * Execute the CreatePatientForUser operation
		 *
		 * @param patient
		 * @param userProfile
		 * @return PatientServiceResponse
		 */
	/*
	 * public void createPatientForUser(PatientDTO patient, UserProfileDTO
	 * userProfile, ResponseUtil response);
	 * 
	 *//**
		 * Execute the AddFacilityForPatient operation
		 *
		 * @param patient
		 * @param facility
		 * @return PatientServiceResponse
		 */
	/*
	 * public void addFacilityForPatient(PatientDTO patient, FacilityDTO
	 * facility, ResponseUtil response);
	 * 
	 *//**
		 * Updates a given patient. Processes and registers registry changes
		 * (ICN and/or facility changes). Only updates to the registry
		 * information, i.e ICN, patient facilities, first name, last name, date
		 * of birth and ssn. Changes to other properties are ignored. Changes
		 * are determines by comparing (based on its primary key) the given and
		 * the current patient (as persisted in the EVault).
		 *
		 * @param patient
		 *            The patient to update.
		 * @return PatientServiceResponse
		 */
	/*
	 * public void updatePatientRegistryInformation(PatientDTO patient,
	 * ResponseUtil response);
	 * 
	 *//**
		 * JAZZ Defect# 20309: If there four or more traits update, DO NOT
		 * Update the user and deactivate the user.
		 *
		 * @param patient
		 *            The patient to invalidate.
		 * @param referenceId
		 *            Denotes a referenceId to use when refering to this action.
		 * @param adminNetworkId
		 * @param reason
		 *            Denotes the reason to deactivate the patient/user.
		 * @param note
		 *            Note for the deactivation of the user.
		 * @return PatientServiceResponse
		 */
	/*
	 * public void deactivatePatientForMultiTraitUpdateError(PatientDTO patient,
	 * String referenceId, String adminNetworkId,
	 * UserProfileDeactivationReasonDTO reason, String note, ResponseUtil
	 * response);
	 * 
	 *//**
		 * Store Patient details in database
		 *
		 * @param patient
		 * @return patient
		 */
	/*
	 * public PatientDTO savePatient(PatientDTO patient);
	 * 
	 *//**
		 * Store both the patient and the patient's associated facilities.
		 * 
		 * @param patient
		 *            The patient being stored.
		 * @return The persisted patient.
		 *//*
		 * public PatientDTO savePatientWithFacilities(PatientDTO patient);
		 * 
		 * public void healthSummaryBatch();
		 */

}
